/*
*  Arnold emulator (c) Copyright, Kevin Thacker 1995-2015
*
*  This file is part of the Arnold emulator source code distribution.
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* ROMDIS?? */

/* MirageImager emulation */
/* original ROM is scrambled:

D0-D7
D1-D5
D2-D3
D3-D1
D4-D0
D5-D2
D6-D4
D7-D6
*/
/* Mirage imager has two read/write ports which it uses to access on-board ram */
#include "cpc.h"
#include "emudevice.h"

typedef struct
{
	unsigned char Ram[8192];

	unsigned char SystemROM[8192];

	/* bit 0 is rom enable/disable state */
	unsigned char RomState;
} MirageImager;

static MirageImager mirage;

void MirageImager_SetROM(const unsigned char *pROM, const unsigned long RomLength)
{
    EmuDevice_CopyRomData(mirage.SystemROM, sizeof(mirage.SystemROM), pROM, RomLength);

}


void MirageImager_ClearROM(void)
{
	EmuDevice_ClearRomData(mirage.SystemROM, sizeof(mirage.SystemROM));

}

void MirageImager_MemoryRethink(MemoryData *pData)
{
    if ((mirage.RomState & (1<<0))!=0)
    {
        /* read only */
        pData->pReadPtr[7] = mirage.Ram-0x0c000;
        pData->pReadPtr[6] = mirage.Ram-0x0c000;
		pData->pReadMaskPtr[7] = GetDefaultReadMask() - 0x0c000;
		pData->pReadMaskPtr[6] = GetDefaultReadMask() - 0x0c000;

        pData->pWritePtr[7] = mirage.Ram-0x0c000;
        pData->pWritePtr[6] = mirage.Ram - 0x0c000;


			pData->bRamDisable[7] = FALSE;
			pData->bRamDisable[6] = FALSE;
			pData->bRomDisable[7] = TRUE;
			pData->bRomDisable[6] = TRUE;


    }

    if ((mirage.RomState & (1<<1))!=0)
    {
       unsigned char *pRomPtr = NULL;

        pRomPtr = mirage.SystemROM;

        /* read only */
        pData->pReadPtr[1] = pRomPtr;
        pData->pReadPtr[0] = pRomPtr;
		pData->pReadMaskPtr[1] = GetDefaultReadMask() - 0x00000;
		pData->pReadMaskPtr[0] = GetDefaultReadMask() - 0x00000;

        /* we provide a rom */
     //   pData->bRomEnable[0] = TRUE;
      //  pData->bRomEnable[1] = TRUE;
        pData->bRomDisable[0] = TRUE;
        pData->bRomDisable[1] = TRUE;

    }
}

void MirageImager_Reset(void)
{
    /* reset enables their rom */
    mirage.RomState = (1<<1);
}

/* call here when MirageImager stop button is pressed */
void    MirageImager_Stop(void)
{
    mirage.RomState = (1<<1);

/* not going to work.... */
    CPU_SetNMIState(FALSE);
    CPU_SetNMIState(TRUE);
    CPU_SetNMIState(FALSE);

	Computer_RethinkMemory();

}


static EmuDeviceRom MirageImagerRom=
{
    "MirageImager System ROM",
	"SystemRom",
    MirageImager_SetROM,
	MirageImager_ClearROM,
	false,
	false,
	sizeof(mirage.SystemROM),
    0   /* ROM CRC - todo */

};

static EmuDeviceButton MirageImagerStopButton[2]=
{
    {
        "Stop Button (Red)",
        MirageImager_Stop
    },
    {
        "Reset Button (Black)",
        MirageImager_Reset
    }
};


BOOL MirageImagerRead(Z80_WORD Port,Z80_BYTE *pDeviceData)
{
	*pDeviceData = mirage.Ram[Port & 0x0ff];
	return TRUE;
}


void MirageImagerWrite(Z80_WORD Port, Z80_BYTE Data)
{
	mirage.Ram[Port&0x0ff] = Data;
}


static CPCPortRead MirageImagerPortRead=
{
    0x0ffff, /* and */
    0x0fbf0, /* cmp */
    MirageImagerRead
};

static CPCPortWrite MirageImagerPortWrite=
{
    0x0ffff, /* and */
    0x0fbf0, /* cmp */
    MirageImagerWrite
};

void MirageImagerDevice_Init(void)
{
	mirage.RomState = 0;
}

static EmuDevice MirageImagerDevice=
{
	NULL,
	MirageImagerDevice_Init,
	NULL,
	"MirageImager",
	"MirageImager",
	"Mirage Imager",
	CONNECTION_EXPANSION,   /* connects to expansion */
	0,
  1,
  &MirageImagerPortRead,
  1,
 &MirageImagerPortWrite,
 0,                /* no memory read*/
 NULL,
 0,                /* no memory write */
 NULL,
 MirageImager_Reset,
  MirageImager_MemoryRethink,
  MirageImager_Reset,
	0,                      /* no switches */
	NULL,
    2,                      /* 2 buttons */
    MirageImagerStopButton,
	0,
	NULL,
	1,                      /* 1 onboard roms */
    &MirageImagerRom,
    NULL,                   /* no cursor function */
    NULL,                   /* no generic roms */
	NULL,					/* printer */
	NULL,					/* joystick */
	0,
	NULL,					/* memory ranges */
	NULL, /* sound */
	NULL, /* lpen */
	NULL, /* reti */
	NULL, /* ack maskable interrupt */
	NULL, /* dkram data */
	NULL, /* device ram */
	NULL, /* device backup */
	NULL
};

void MirageImager_Init(void)
{
	RegisterDevice(&MirageImagerDevice);
}










